import { Tooltip } from "@patternfly/react-core/dist/esm/components/Tooltip/Tooltip.js";
import QuestionIcon from "@patternfly/react-icons/dist/esm/icons/question-icon";
import SecurityIcon from "@patternfly/react-icons/dist/esm/icons/security-icon";
import propTypes from 'prop-types';
import React from 'react';
import { colorList, impactList } from './consts';

var Shield = function Shield(_ref) {
  var impact = _ref.impact,
      hasLabel = _ref.hasLabel,
      hasTooltip = _ref.hasTooltip,
      size = _ref.size;
  var unknownLabel = 'Unknown';
  var attributes = impactList[impact] || {
    title: unknownLabel,
    color: colorList["default"]
  };
  var badge = impactList[impact] ? /*#__PURE__*/React.createElement(SecurityIcon, {
    "aria-hidden": "false",
    "aria-label": attributes.title,
    size: size,
    color: attributes.color
  }) : /*#__PURE__*/React.createElement(QuestionIcon, {
    "aria-hidden": "false",
    "aria-label": unknownLabel,
    size: size,
    color: colorList["default"]
  });
  var body = /*#__PURE__*/React.createElement("span", null, badge, " ", hasLabel && attributes.title);
  return /*#__PURE__*/React.createElement("span", null, hasTooltip ? /*#__PURE__*/React.createElement(Tooltip, {
    content: /*#__PURE__*/React.createElement("div", null, attributes.message),
    position: 'bottom'
  }, body) : body);
};

Shield.defaultProps = {
  impact: 'N/A',
  hasLabel: false,
  size: 'sm',
  hasTooltip: true
};
Shield.propTypes = {
  impact: propTypes.oneOfType([propTypes.string, propTypes.number]),
  hasLabel: propTypes.bool,
  size: propTypes.string,
  // sm, md, lg and xl,
  label: propTypes.bool,
  hasTooltip: propTypes.bool
};
export default Shield;