import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import React from 'react';
import propTypes from 'prop-types';
import classNames from 'classnames';
export var SkeletonSize = {
  xs: 'xs',
  sm: 'sm',
  md: 'md',
  lg: 'lg'
};
import "../../Skeleton/./skeleton.css";

var Skeleton = function Skeleton(_ref) {
  var size = _ref.size,
      isDark = _ref.isDark,
      className = _ref.className,
      props = _objectWithoutProperties(_ref, ["size", "isDark", "className"]);

  var skeletonClasses = classNames('ins-c-skeleton', "ins-c-skeleton__".concat(size), _defineProperty({}, "ins-m-dark", isDark), className);
  return /*#__PURE__*/React.createElement("div", _extends({
    className: skeletonClasses
  }, props), "\xA0");
};

export default Skeleton;
Skeleton.propTypes = {
  className: propTypes.string,
  size: propTypes.oneOf(Object.values(SkeletonSize)),
  isDark: propTypes.bool
};
Skeleton.defaultProps = {
  size: SkeletonSize.md,
  isDark: false
};