import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { Modal } from "@patternfly/react-core/dist/esm/components/Modal/Modal.js";
import { Button } from "@patternfly/react-core/dist/esm/components/Button/Button.js";
import "../../Wizard/./wizard.css";

var Wizard = /*#__PURE__*/function (_Component) {
  _inherits(Wizard, _Component);

  var _super = _createSuper(Wizard);

  function Wizard() {
    var _this;

    _classCallCheck(this, Wizard);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      currentStep: 0
    });

    _defineProperty(_assertThisInitialized(_this), "handleNextModalStep", function () {
      _this.setState(function (_ref) {
        var currentStep = _ref.currentStep;
        return {
          currentStep: currentStep + 1
        };
      });
    });

    _defineProperty(_assertThisInitialized(_this), "handlePreviousModalStep", function () {
      _this.setState(function (_ref2) {
        var currentStep = _ref2.currentStep;
        return {
          currentStep: currentStep - 1
        };
      });
    });

    _defineProperty(_assertThisInitialized(_this), "handleOnClose", function (submit) {
      var result = _this.props.onClose(submit);

      if (result === false) {
        return;
      }

      _this.setState({
        currentStep: 0
      });
    });

    _defineProperty(_assertThisInitialized(_this), "handleKeyPress", function (event) {
      if (event.key === 'Enter' && _this.props.isValidated === true) {
        _this.handleNextModalStep();
      }
    });

    return _this;
  }

  _createClass(Wizard, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          isLarge = _this$props.isLarge,
          title = _this$props.title,
          className = _this$props.className,
          isOpen = _this$props.isOpen,
          isValidated = _this$props.isValidated,
          confirmAction = _this$props.confirmAction,
          props = _objectWithoutProperties(_this$props, ["isLarge", "title", "className", "isOpen", "isValidated", "confirmAction"]);

      var wizardClasses = classNames('ins-c-wizard', className);
      var renderModalActions = [// Conditionally render 'confirm' button if on last page
      this.state.currentStep < this.props.content.length - 1 ? /*#__PURE__*/React.createElement(Button, {
        key: "Next",
        action: "next",
        variant: "primary",
        isDisabled: !isValidated,
        onClick: this.handleNextModalStep
      }, "Next") : /*#__PURE__*/React.createElement(Button, {
        key: "confirm",
        action: "confirm",
        variant: "primary",
        isDisabled: !isValidated,
        onClick: function onClick() {
          return _this2.handleOnClose(true);
        }
      }, confirmAction), // Conditionally render 'previous' button if not on first page
      this.state.currentStep !== 0 && /*#__PURE__*/React.createElement(Button, {
        key: "back",
        action: "back",
        variant: "secondary",
        onClick: this.handlePreviousModalStep
      }, " Back "), /*#__PURE__*/React.createElement(Button, {
        key: "cancel",
        action: "cancel",
        variant: "secondary",
        onClick: function onClick() {
          return _this2.handleOnClose(false);
        }
      }, "Cancel")];
      return /*#__PURE__*/React.createElement(Modal, _extends({}, props, {
        onKeyPress: this.handleKeyPress,
        variant: "large",
        title: title,
        className: wizardClasses,
        isOpen: isOpen,
        onClose: function onClose() {
          return _this2.handleOnClose(false);
        },
        actions: renderModalActions
      }), this.props.content[this.state.currentStep]);
    }
  }]);

  return Wizard;
}(Component);

Wizard.propTypes = {
  isValidated: PropTypes.bool,
  isLarge: PropTypes.bool,
  title: PropTypes.string,
  className: PropTypes.string,
  confirmAction: PropTypes.string,
  isOpen: PropTypes.any,
  content: PropTypes.array,
  onClose: PropTypes.func
};
Wizard.defaultProps = {
  onClose: function onClose(f) {
    return f;
  },
  isValidated: true,
  confirmAction: 'Confirm'
};
export default Wizard;