"use strict";
/* Copyright Contributors to the Open Cluster Management project */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmEmptyState = exports.AcmEmptyStateImage = void 0;
var react_core_1 = require("@patternfly/react-core");
var react_1 = __importDefault(require("react"));
var EmptyPageIcon_png_1 = __importDefault(require("../assets/EmptyPageIcon.png"));
var EmptyTableIcon_png_1 = __importDefault(require("../assets/EmptyTableIcon.png"));
var Folder_png_1 = __importDefault(require("../assets/Folder.png"));
var AcmEmptyStateImage;
(function (AcmEmptyStateImage) {
    AcmEmptyStateImage[AcmEmptyStateImage["folder"] = Folder_png_1.default] = "folder";
})(AcmEmptyStateImage = exports.AcmEmptyStateImage || (exports.AcmEmptyStateImage = {}));
function AcmEmptyState(props) {
    var _a;
    return (react_1.default.createElement(react_core_1.EmptyState, { variant: react_core_1.EmptyStateVariant.large },
        props.showIcon !== false && (react_1.default.createElement("img", { src: (_a = props.image) !== null && _a !== void 0 ? _a : (props.isEmptyTableState ? EmptyTableIcon_png_1.default : EmptyPageIcon_png_1.default), style: { width: props.isEmptyTableState ? '65%' : '50%' }, alt: "Empty state" })),
        react_1.default.createElement(react_core_1.Title, { headingLevel: "h4", size: "lg" }, props.title),
        react_1.default.createElement(react_core_1.EmptyStateBody, null, props.message),
        react_1.default.createElement(react_core_1.EmptyStatePrimary, null, props.action)));
}
exports.AcmEmptyState = AcmEmptyState;
//# sourceMappingURL=AcmEmptyState.js.map