"use strict";
/* Copyright Contributors to the Open Cluster Management project */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmRefreshTime = void 0;
var react_1 = __importDefault(require("react"));
var styles_1 = require("@material-ui/styles");
var moment_1 = __importDefault(require("moment"));
var react_core_1 = require("@patternfly/react-core");
var useStyles = styles_1.makeStyles({
    timestamp: {
        display: 'flex',
        justifyContent: 'flex-end',
        alignItems: 'center',
        color: 'var(--pf-global--Color--200)',
        fontSize: '10px',
        lineHeight: '20px',
        '& .pf-c-spinner': {
            marginRight: '.4rem',
        },
    },
});
var AcmRefreshTime = function (props) {
    var classes = useStyles();
    var reloading = props.reloading, timestamp = props.timestamp;
    var time = moment_1.default(new Date(timestamp)).format('LTS');
    return (react_1.default.createElement("div", { className: classes.timestamp },
        reloading && react_1.default.createElement(react_core_1.Spinner, { size: "sm" }),
        react_1.default.createElement("p", null,
            "Last update: ",
            time)));
};
exports.AcmRefreshTime = AcmRefreshTime;
//# sourceMappingURL=AcmRefreshTime.js.map