"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.topNodes = exports.NodeStatus = exports.ResourceUsage = void 0;
const util_1 = require("./util");
class ResourceUsage {
    constructor(Capacity, RequestTotal, LimitTotal) {
        this.Capacity = Capacity;
        this.RequestTotal = RequestTotal;
        this.LimitTotal = LimitTotal;
    }
}
exports.ResourceUsage = ResourceUsage;
class NodeStatus {
    constructor(Node, CPU, Memory) {
        this.Node = Node;
        this.CPU = CPU;
        this.Memory = Memory;
    }
}
exports.NodeStatus = NodeStatus;
async function topNodes(api) {
    // TODO: Support metrics APIs in the client and this library
    const nodes = await api.listNode();
    const result = [];
    for (const node of nodes.body.items) {
        const availableCPU = util_1.quantityToScalar(node.status.allocatable.cpu);
        const availableMem = util_1.quantityToScalar(node.status.allocatable.memory);
        let totalPodCPU = 0;
        let totalPodCPULimit = 0;
        let totalPodMem = 0;
        let totalPodMemLimit = 0;
        let pods = await util_1.podsForNode(api, node.metadata.name);
        pods = pods.filter((pod) => pod.status.phase === 'Running');
        pods.forEach((pod) => {
            const cpuTotal = util_1.totalCPU(pod);
            totalPodCPU = util_1.add(totalPodCPU, cpuTotal.request);
            totalPodCPULimit = util_1.add(totalPodCPULimit, cpuTotal.limit);
            const memTotal = util_1.totalMemory(pod);
            totalPodMem = util_1.add(totalPodMem, memTotal.request);
            totalPodMemLimit = util_1.add(totalPodMemLimit, memTotal.limit);
        });
        const cpuUsage = new ResourceUsage(availableCPU, totalPodCPU, totalPodCPULimit);
        const memUsage = new ResourceUsage(availableMem, totalPodMem, totalPodMemLimit);
        result.push(new NodeStatus(node, cpuUsage, memUsage));
    }
    return result;
}
exports.topNodes = topNodes;
//# sourceMappingURL=top.js.map