/// <reference types="node" />
import request = require('request');
import { Duplex } from 'stream';
import { KubeConfig } from './config';
export interface WatchUpdate {
    type: string;
    object: object;
}
export interface RequestResult {
    pipe(stream: Duplex): void;
    on(ev: string, cb: (arg: any) => void): void;
    abort(): void;
}
export interface Response {
    statusCode: number;
    statusMessage: string;
}
export interface RequestInterface {
    webRequest(opts: request.OptionsWithUri): RequestResult;
}
export declare class DefaultRequest implements RequestInterface {
    private requestImpl;
    constructor(requestImpl?: (opts: request.OptionsWithUri) => request.Request);
    webRequest(opts: request.OptionsWithUri): RequestResult;
}
export declare class Watch {
    static SERVER_SIDE_CLOSE: object;
    config: KubeConfig;
    private readonly requestImpl;
    constructor(config: KubeConfig, requestImpl?: RequestInterface);
    watch(path: string, queryParams: any, callback: (phase: string, apiObj: any, watchObj?: any) => void, done: (err: any) => void): Promise<any>;
}
