"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRows = exports.calculateActiveFilters = exports.calculateMeta = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _get = _interopRequireDefault(require("lodash/get"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var calculateMeta = function calculateMeta(meta) {
  return _objectSpread({
    itemCount: meta.count,
    perPage: meta.limit || 10,
    page: (meta.offset || 0) / (meta.limit || 10) + 1
  }, meta);
};

exports.calculateMeta = calculateMeta;

var calculateActiveFilters = function calculateActiveFilters(activeFilter, value, key) {
  return value && value.length > 0 && activeFilter && {
    category: activeFilter.label,
    type: activeFilter.filterKey,
    chips: activeFilter.filterValues.items && activeFilter.filterValues.items.length > 0 ? (Array.isArray(value) ? value : [value]).map(function (oneValue) {
      var currFilter = activeFilter.filterValues.items.find(function (_ref) {
        var currValue = _ref.value;
        return "".concat(currValue) === oneValue;
      });
      return {
        name: (currFilter || {
          textual: oneValue
        }).textual,
        value: oneValue,
        key: key
      };
    }) : [{
      name: value,
      key: key
    }]
  };
};

exports.calculateActiveFilters = calculateActiveFilters;

var createRows = function createRows(data, columns, expanded, detail) {
  return data.map(function (oneRule, ruleKey) {
    return [{
      cells: columns.map(function (_ref2, cellKey) {
        var selector = _ref2.selector;
        return {
          title: typeof selector === 'function' ? selector(oneRule, ruleKey, cellKey) : (0, _get["default"])(oneRule, selector, 'Not found')
        };
      }),
      isOpen: !!oneRule.isOpen || expanded.includes(oneRule.rule_id) || expanded.includes(ruleKey),
      ruleId: oneRule.rule_id
    }, detail && {
      parent: ruleKey * 2,
      fullWidth: true,
      noPadding: true,
      cells: [{
        title: typeof detail === 'function' ? detail(oneRule, ruleKey) : detail
      }]
    }];
  });
};

exports.createRows = createRows;