function createImperativePromise(promiseArg) {
    var resolve = null;
    var reject = null;
    var wrappedPromise = new Promise(function (_resolve, _reject) {
        resolve = _resolve;
        reject = _reject;
    });
    promiseArg && promiseArg.then(function (val) {
        resolve && resolve(val);
    }, function (error) {
        reject && reject(error);
    });
    return {
        promise: wrappedPromise,
        resolve: function (value) {
            resolve && resolve(value);
        },
        reject: function (reason) {
            reject && reject(reason);
        },
        cancel: function () {
            resolve = null;
            reject = null;
        }
    };
}

export { createImperativePromise };
//# sourceMappingURL=index.es.js.map
