"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartGroup = exports.ChartGroupSortOrder = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const victory_group_1 = require("victory-group");
const ChartContainer_1 = require("../ChartContainer");
const ChartUtils_1 = require("../ChartUtils");
var ChartGroupSortOrder;
(function (ChartGroupSortOrder) {
    ChartGroupSortOrder["ascending"] = "ascending";
    ChartGroupSortOrder["descending"] = "descending";
})(ChartGroupSortOrder = exports.ChartGroupSortOrder || (exports.ChartGroupSortOrder = {}));
const ChartGroup = (_a) => {
    var { ariaDesc, ariaTitle, children, containerComponent = React.createElement(ChartContainer_1.ChartContainer, null), themeColor, themeVariant, 
    // destructure last
    theme = ChartUtils_1.getTheme(themeColor, themeVariant) } = _a, rest = tslib_1.__rest(_a, ["ariaDesc", "ariaTitle", "children", "containerComponent", "themeColor", "themeVariant", "theme"]);
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign(Object.assign({ desc: ariaDesc, title: ariaTitle, theme }, containerComponent.props), { className: ChartUtils_1.getClassName({ className: containerComponent.props.className }) // Override VictoryContainer class name
     }));
    // Note: containerComponent is required for theme
    return (React.createElement(victory_group_1.VictoryGroup, Object.assign({ containerComponent: container, theme: theme }, rest), children));
};
exports.ChartGroup = ChartGroup;
exports.ChartGroup.displayName = 'ChartGroup';
// Note: VictoryGroup.role must be hoisted
hoist_non_react_statics_1.default(exports.ChartGroup, victory_group_1.VictoryGroup);
//# sourceMappingURL=ChartGroup.js.map