"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.debounceFunction = void 0;

var _awesomeDebouncePromise = _interopRequireDefault(require("awesome-debounce-promise"));

/**
 * Async debounce factory functions.
 * @param {Function} asyncFunction async function to be debounced
 * @param {number} [time = 800] delay in ms
 * @param {Object} [config = {onlyResolvesLast: true}] <a target="_blank" href="https://github.com/slorber/awesome-debounce-promise#options">more details</a>
 */
var debounceFunction = function debounceFunction(asyncFunction) {
  var time = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 800;
  var config = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {
    onlyResolvesLast: true
  };
  return (0, _awesomeDebouncePromise["default"])(asyncFunction, time, config);
};

exports.debounceFunction = debounceFunction;
var _default = debounceFunction;
exports["default"] = _default;