"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var prop_types_1 = __importDefault(require("prop-types"));
var react_1 = __importDefault(require("react"));
var classnames_1 = __importDefault(require("classnames"));
var Input_1 = __importDefault(require("./Input"));
var LabeledInput = function (_a) {
    var _b = _a.type, type = _b === void 0 ? 'text' : _b, className = _a.className, children = _a.children, name = _a.name, props = __rest(_a, ["type", "className", "children", "name"]);
    name = name || new Date().getTime() + Math.random().toString(36);
    return (react_1.default.createElement("label", { className: (0, classnames_1.default)('pf-c-form__label', className), htmlFor: name },
        react_1.default.createElement(Input_1.default, __assign({}, props, { type: type, name: name, id: name })),
        " ",
        children));
};
LabeledInput.propTypes = {
    type: prop_types_1.default.string,
    className: prop_types_1.default.string,
    children: prop_types_1.default.node,
    name: prop_types_1.default.string,
};
exports.default = LabeledInput;
//# sourceMappingURL=LabeledInput.js.map