"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var react_core_1 = require("@scalprum/react-core");
var react_router_dom_1 = require("react-router-dom");
var react_redux_1 = require("react-redux");
var react_core_2 = require("@patternfly/react-core");
var InventoryLoadError_1 = __importDefault(require("./InventoryLoadError"));
var classnames_1 = __importDefault(require("classnames"));
var BaseAppInfo = function (props) {
    var history = (0, react_router_dom_1.useHistory)();
    var store = (0, react_redux_1.useStore)();
    var Cmp = props.component;
    return (react_1.default.createElement(Cmp, { className: (0, classnames_1.default)(props.className, 'inventory') },
        react_1.default.createElement(react_1.Suspense, { fallback: props.fallback },
            react_1.default.createElement(react_core_1.ScalprumComponent, __assign({ history: history, store: store, appName: "inventory", module: "./AppInfo", scope: "inventory", ErrorComponent: react_1.default.createElement(InventoryLoadError_1.default, __assign({ component: "InventoryDetailHead", history: history, store: store }, props)), ref: props.innerRef }, props)))));
};
BaseAppInfo.propTypes = {
    fallback: prop_types_1.default.node,
    innerRef: prop_types_1.default.object,
    component: prop_types_1.default.string,
    className: prop_types_1.default.string,
};
var AppInfo = react_1.default.forwardRef(function (props, ref) { return react_1.default.createElement(BaseAppInfo, __assign({ innerRef: ref }, props)); });
AppInfo.propTypes = {
    fallback: prop_types_1.default.node,
    component: prop_types_1.default.string,
    className: prop_types_1.default.string,
};
AppInfo.defaultProps = {
    fallback: (react_1.default.createElement(react_core_2.Bullseye, { className: "pf-u-p-lg" },
        react_1.default.createElement(react_core_2.Spinner, { size: "xl" }))),
    component: 'section',
};
exports.default = AppInfo;
//# sourceMappingURL=AppInfo.js.map