"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.flipDirection = void 0;
var react_1 = __importDefault(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var react_table_1 = require("@patternfly/react-table");
var react_core_1 = require("@patternfly/react-core");
var react_icons_1 = require("@patternfly/react-icons");
function flipDirection(direction) {
    return direction === react_table_1.SortByDirection.asc ? react_table_1.SortByDirection.desc : react_table_1.SortByDirection.asc;
}
exports.flipDirection = flipDirection;
var SortBy = function (_a) {
    var direction = _a.direction, onSortChange = _a.onSortChange;
    return (react_1.default.createElement(react_core_1.Button, { variant: "plain", onClick: function (e) { return onSortChange(e, flipDirection(direction)); } }, direction === react_table_1.SortByDirection.asc ? react_1.default.createElement(react_icons_1.SortAmountUpIcon, { size: "sm" }) : react_1.default.createElement(react_icons_1.SortAmountDownIcon, { size: "sm" })));
};
SortBy.propTypes = {
    direction: prop_types_1.default.oneOf(Object.values(react_table_1.SortByDirection)),
    onSortChange: prop_types_1.default.func,
};
SortBy.defaultProps = {
    direction: react_table_1.SortByDirection.asc,
    onSortChange: function () { return undefined; },
};
exports.default = SortBy;
//# sourceMappingURL=SortBy.js.map