"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var classnames_1 = __importDefault(require("classnames"));
require("./tab-layout.css");
var TabLayout = function (_a) {
    var children = _a.children, items = _a.items, classNames = _a.classNames, active = _a.active, onTabClick = _a.onTabClick, props = __rest(_a, ["children", "items", "classNames", "active", "onTabClick"]);
    return (react_1.default.createElement("section", __assign({}, props, { className: (0, classnames_1.default)(classNames, 'ins-tab-layout'), "widget-type": "InsightsTabs" }),
        react_1.default.createElement("div", { className: "ins-tabs" }, items.map(function (oneItem) { return (react_1.default.createElement("div", { key: oneItem.name, className: (0, classnames_1.default)({ active: oneItem.name === active }), onClick: function (event) { return onTabClick(event, oneItem); }, "widget-type": "InsightsTabsItem", "widget-id": oneItem.name }, oneItem.title)); })),
        react_1.default.createElement("div", { className: "ins-tab-content" }, children)));
};
TabLayout.propTypes = {
    items: prop_types_1.default.arrayOf(prop_types_1.default.shape({
        name: prop_types_1.default.string,
        title: prop_types_1.default.node,
    })),
    children: prop_types_1.default.node,
    classNames: prop_types_1.default.string,
    active: prop_types_1.default.string,
    onTabClick: prop_types_1.default.func,
};
TabLayout.defaultProps = {
    items: [],
    onTabClick: function () { return undefined; },
};
exports.default = TabLayout;
//# sourceMappingURL=TabLayout.js.map