var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React from 'react';
import classNames from 'classnames';
import CriticalBattery from './CriticalBattery';
import HighBattery from './HighBattery';
import MediumBattery from './MediumBattery';
import LowBattery from './LowBattery';
import NullBattery from './NullBattery';
import './battery.css';
var Battery = function (_a) {
    var _b, _c;
    var severity = _a.severity, label = _a.label, labelHidden = _a.labelHidden, className = _a.className, props = __rest(_a, ["severity", "label", "labelHidden", "className"]);
    var batteryClasses = classNames(className, 'ins-battery', (_b = {}, _b["ins-battery-".concat(severity)] = severity !== undefined, _b));
    var ariaLabels = {};
    if (labelHidden) {
        ariaLabels = (_c = {}, _c['aria-label'] = severity + ' ' + label, _c);
    }
    var batteryLevels = function (severity) {
        switch (severity) {
            case 'critical':
            case 4:
                return React.createElement(CriticalBattery, null);
            case 'high':
            case 'error':
            case 3:
                return React.createElement(HighBattery, null);
            case 'medium':
            case 'warn':
            case 2:
                return React.createElement(MediumBattery, null);
            case 'low':
            case 'info':
            case 1:
                return React.createElement(LowBattery, null);
            default:
                console.error('Warning: Unsupported value presented to battery component');
                return React.createElement(NullBattery, null);
        }
    };
    return (React.createElement(React.Fragment, null,
        React.createElement("i", __assign({ className: batteryClasses }, ariaLabels, props, { "widget-type": "InsightsBattery", "widget-id": label }),
            React.createElement("svg", { version: "1.1", id: "battery_svg", x: "0px", y: "0px", viewBox: "0 0 448 512", style: { enableBackground: 'new 0 0 448 512' }, shapeRendering: "geometricpresision" },
                React.createElement("path", { style: {
                        fill: 'none',
                        fillOpacity: 1,
                        stroke: '#969696',
                        strokeWidth: 41.96378708,
                        strokeLinejoin: 'round',
                        strokeMiterlimit: 4,
                        strokeDasharray: 'none',
                        strokeDashoffset: 0,
                        strokeOpacity: 1,
                    }, d: "m 144.16452,21.032222 h 159.67454 q 123.1748,0 123.1748,128.667868 v 212.64759 q 0,128.66788 -123.1748,128.66788 H 144.16452 q -123.174811,0 -123.174811,-128.66788 V 149.70009 q 0,-128.667868 123.174811,-128.667868 z" }),
                batteryLevels(severity))),
        !labelHidden && React.createElement("span", { className: "label" },
            " ",
            label,
            " ")));
};
export default Battery;
//# sourceMappingURL=Battery.js.map