var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React, { Component } from 'react';
import PaginationNext from './PaginationNext';
import PropTypes from 'prop-types';
export var dropDirection = {
    up: 'up',
    down: 'down',
};
var pager = [10, 15, 20, 25, 50];
var Pagination = (function (_super) {
    __extends(Pagination, _super);
    function Pagination() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.setPage = function (page, debounce) {
            var currPage = _this.props.page;
            var perPage = _this.props.itemsPerPage || pager[0];
            var maxPage = Math.ceil(_this.props.numberOfItems / perPage);
            page = isNaN(page) ? currPage : page;
            page = page > maxPage ? maxPage : page < 0 ? 0 : page;
            _this.props.hasOwnProperty('onSetPage') && _this.props.onSetPage(page, debounce);
        };
        return _this;
    }
    Pagination.prototype.render = function () {
        var _this = this;
        var _a = this.props, page = _a.page, onSetPage = _a.onSetPage, numberOfItems = _a.numberOfItems, itemsPerPage = _a.itemsPerPage, perPageOptions = _a.perPageOptions, onPerPageSelect = _a.onPerPageSelect, onFirstPage = _a.onFirstPage, onLastPage = _a.onLastPage, onPreviousPage = _a.onPreviousPage, onNextPage = _a.onNextPage, props = __rest(_a, ["page", "onSetPage", "numberOfItems", "itemsPerPage", "perPageOptions", "onPerPageSelect", "onFirstPage", "onLastPage", "onPreviousPage", "onNextPage"]);
        var pagerOptions = perPageOptions || pager;
        var perPage = itemsPerPage || pagerOptions[0];
        var lastPage = Math.ceil(numberOfItems / perPage);
        var lastIndex = numberOfItems === 0 ? 0 : page === lastPage ? numberOfItems : page * perPage;
        var firstIndex = numberOfItems === 0 ? 0 : (page - 1) * perPage + 1;
        return (React.createElement(PaginationNext, __assign({}, props, { itemCount: this.props.numberOfItems, className: "ins-c-pagination-next", itemsStart: firstIndex, itemsEnd: lastIndex, lastPage: lastPage || 1, dropDirection: this.props.direction, onFirstPage: onFirstPage, onLastPage: onLastPage, onPreviousPage: onPreviousPage, onNextPage: onNextPage, perPage: perPage, onSetPerPage: function (_event, value) { return _this.props.onPerPageSelect(value); }, page: this.props.page, setPage: function (event, page) { return _this.setPage(page, event.currentTarget.tagName === 'INPUT'); }, perPageOptions: pagerOptions.map(function (value) { return ({
                title: value,
                value: value,
            }); }) })));
    };
    return Pagination;
}(Component));
Pagination.propTypes = {
    direction: PropTypes.oneOf(Object.keys(dropDirection)),
    viewType: PropTypes.string,
    itemsPerPage: PropTypes.number,
    perPageOptions: PropTypes.arrayOf(PropTypes.number),
    numberOfItems: PropTypes.number.isRequired,
    onSetPage: PropTypes.func,
    onPerPageSelect: PropTypes.func,
    onFirstPage: PropTypes.func,
    onLastPage: PropTypes.func,
    onPreviousPage: PropTypes.func,
    onNextPage: PropTypes.func,
    page: PropTypes.number,
};
Pagination.defaultProps = {
    page: 1,
};
export default Pagination;
//# sourceMappingURL=Pagination.js.map