var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React from 'react';
import PropTypes from 'prop-types';
import { Button, ButtonVariant, TextInput } from '@patternfly/react-core';
import { AngleDoubleLeftIcon, AngleLeftIcon, AngleDoubleRightIcon, AngleRightIcon } from '@patternfly/react-icons';
var PaginationNav = function (_a) {
    var lastPage = _a.lastPage, setPage = _a.setPage, pageTitle = _a.pageTitle, amountOfPages = _a.amountOfPages, page = _a.page, onFirstPage = _a.onFirstPage, onLastPage = _a.onLastPage, onPreviousPage = _a.onPreviousPage, onNextPage = _a.onNextPage, props = __rest(_a, ["lastPage", "setPage", "pageTitle", "amountOfPages", "page", "onFirstPage", "onLastPage", "onPreviousPage", "onNextPage"]);
    return (React.createElement("nav", __assign({ className: "pf-c-pagination__nav", "aria-label": "Pagination" }, props),
        React.createElement(Button, { variant: ButtonVariant.plain, isDisabled: page === 1, "aria-label": "Go to first page", "data-action": "first-page", onClick: function (event) {
                onFirstPage(event);
                setPage(event, 1);
            } },
            React.createElement(AngleDoubleLeftIcon, null)),
        React.createElement(Button, { variant: ButtonVariant.plain, isDisabled: page === 1, "aria-label": "Go to previous page", "data-action": "previous-page", onClick: function (event) {
                onPreviousPage(event, page - 1);
                setPage(event, page - 1);
            } },
            React.createElement(AngleLeftIcon, null)),
        React.createElement("div", { className: "pf-c-pagination__nav-page-select", "aria-label": "Current page ".concat(page, " of ").concat(lastPage) },
            React.createElement(TextInput, { className: "pf-c-form-control", "aria-label": "Current page", type: "number", min: "1", "data-action": "set-page", max: amountOfPages, style: { width: "".concat(lastPage.toString().length, "rem"), minWidth: '3rem' }, isReadOnly: amountOfPages === 1, value: page, onChange: function (value, event) {
                    setPage(event, value === '' ? NaN : Number(value));
                } }),
            React.createElement("span", { "aria-hidden": "true" },
                "of ",
                lastPage,
                " ",
                pageTitle)),
        React.createElement(Button, { variant: ButtonVariant.plain, isDisabled: page === lastPage, "aria-label": "Go to next page", "data-action": "next-page", onClick: function (event) {
                onNextPage(event, page + 1);
                setPage(event, page + 1);
            } },
            React.createElement(AngleRightIcon, null)),
        React.createElement(Button, { variant: ButtonVariant.plain, isDisabled: page === lastPage, "aria-label": "Go to last page", "data-action": "last-page", onClick: function (event) {
                onLastPage(event);
                setPage(event, lastPage);
            } },
            React.createElement(AngleDoubleRightIcon, null))));
};
PaginationNav.propTypes = {
    lastPage: PropTypes.number,
    page: PropTypes.number,
    pageTitle: PropTypes.string,
    setPage: PropTypes.func,
    amountOfPages: PropTypes.number,
    onFirstPage: PropTypes.func,
    onLastPage: PropTypes.func,
    onPreviousPage: PropTypes.func,
    onNextPage: PropTypes.func,
};
PaginationNav.defaultProps = {
    pageTitle: 'pages',
    onFirstPage: function () { return undefined; },
    onLastPage: function () { return undefined; },
    onPreviousPage: function () { return undefined; },
    onNextPage: function () { return undefined; },
};
export default PaginationNav;
//# sourceMappingURL=PaginationNav.js.map