var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React, { Fragment } from 'react';
import { Toolbar } from '@patternfly/react-core';
import { useOUIAId } from '@patternfly/react-core/';
import classNames from 'classnames';
import propTypes from 'prop-types';
import './TableToolbar.css';
function generateCount(results) {
    if (results > 1 || results < 1) {
        return "".concat(results, " Results");
    }
    else {
        return "".concat(results, " Result");
    }
}
var TableToolbar = function (_a) {
    var _b;
    var isFooter = _a.isFooter, results = _a.results, className = _a.className, selected = _a.selected, children = _a.children, ouiaId = _a.ouiaId, _c = _a.ouiaSafe, ouiaSafe = _c === void 0 ? true : _c, props = __rest(_a, ["isFooter", "results", "className", "selected", "children", "ouiaId", "ouiaSafe"]);
    var tableToolbarClasses = classNames('ins-c-table__toolbar', (_b = {}, _b["ins-m-footer"] = isFooter, _b), className);
    var ouiaComponentType = 'RHI/TableToolbar';
    var ouiaFinalId = useOUIAId(ouiaComponentType, ouiaId, ouiaSafe);
    return (React.createElement(Fragment, null,
        React.createElement(Toolbar, __assign({ className: tableToolbarClasses, "data-ouia-component-type": ouiaComponentType, "data-ouia-component-id": ouiaFinalId, "data-ouia-safe": ouiaSafe }, props), children),
        (results >= 0 || selected >= 0) && (React.createElement("div", { className: "ins-c-table__toolbar-results" },
            results >= 0 && React.createElement("span", { className: "ins-c-table__toolbar-results-count" },
                " ",
                generateCount(results),
                " "),
            selected >= 0 && React.createElement("span", { className: "ins-c-table__toolbar-results-selected" },
                " ",
                selected,
                " Selected ")))));
};
export default TableToolbar;
TableToolbar.propTypes = {
    isFooter: propTypes.bool,
    results: propTypes.number,
    children: propTypes.any,
    className: propTypes.string,
    selected: propTypes.number,
    ouiaId: propTypes.string,
    ouiaSafe: propTypes.bool,
};
TableToolbar.defaultProps = {
    isFooter: false,
};
//# sourceMappingURL=TableToolbar.js.map