"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var getVariant_1 = __importDefault(require("./getVariant"));
var useScreen = function () {
    var _a = (0, react_1.useState)(function () { return (0, getVariant_1.default)(); }), variant = _a[0], setVariant = _a[1];
    var prev = (0, react_1.useRef)(variant);
    (0, react_1.useEffect)(function () {
        function handleResize() {
            var newVariant = (0, getVariant_1.default)();
            if (newVariant !== prev.current) {
                prev.current = newVariant;
                setVariant(newVariant);
            }
        }
        window.addEventListener('resize', handleResize);
        return function () { return window.removeEventListener('resize', handleResize); };
    }, []);
    return variant;
};
exports.default = useScreen;
//# sourceMappingURL=useScreenSize.js.map