"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isTransformable = exports.isPlainObject = exports.isFormData = exports.isURLSearchParams = void 0;
var isURLSearchParams = function (value) {
    return (typeof URLSearchParams !== 'undefined' && value instanceof URLSearchParams);
};
exports.isURLSearchParams = isURLSearchParams;
var isFormData = function (value) {
    return typeof FormData !== 'undefined' && value instanceof FormData;
};
exports.isFormData = isFormData;
var isPlainObject = function (value) {
    return (typeof value === 'object' &&
        value !== null &&
        Object.prototype.toString.call(value) === '[object Object]');
};
exports.isPlainObject = isPlainObject;
var isTransformable = function (value) {
    return (Array.isArray(value) ||
        exports.isPlainObject(value) ||
        exports.isFormData(value) ||
        exports.isURLSearchParams(value));
};
exports.isTransformable = isTransformable;
