"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = DateFormat;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _helper = require("./helper");

/**
 * A component that formats date to a unified CRC format.
 * Relative date format adds a tooltip with a full date string.
 */
function DateFormat(_ref) {
  var date = _ref.date,
      _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'relative' : _ref$type,
      extraTitle = _ref.extraTitle,
      _ref$tooltipProps = _ref.tooltipProps,
      tooltipProps = _ref$tooltipProps === void 0 ? {} : _ref$tooltipProps;
  var dateObj = date instanceof Date ? date : new Date(date); // Prevent treating null as valid. (new Date(null) == new Date(0) returns 1970 Jan 1)

  var invalid = date === undefined || date === null || dateObj.toString() === 'Invalid Date';
  var dateType = invalid ? 'invalid' : type;
  return /*#__PURE__*/_react["default"].createElement(_react["default"].Fragment, null, (0, _helper.dateByType)(dateType, tooltipProps, extraTitle)(dateObj));
}

DateFormat.propTypes = {
  date: _propTypes["default"].oneOfType([_propTypes["default"].instanceOf(Date), _propTypes["default"].string, _propTypes["default"].number]),

  /**
   * Output format of the date
   */
  type: _propTypes["default"].oneOf(['exact', 'onlyDate', 'relative']),

  /**
   * Additional text in the tooltip
   */
  extraTitle: _propTypes["default"].node,

  /**
   * <a target="_blank" href="https://www.patternfly.org/v4/components/tooltip/#props">PF Tooltip props object</a>
   */
  tooltipProps: _propTypes["default"].object
};