"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

require("./labels.css");

var _angleDoubleDownIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/angle-double-down-icon"));

var _angleDoubleUpIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/angle-double-up-icon"));

var _CriticalIcon = _interopRequireDefault(require("./CriticalIcon"));

var _equalsIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/equals-icon"));

var _Label = require("@patternfly/react-core/dist/js/components/Label/Label.js");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var VALUE_TO_STATE = {
  1: {
    icon: /*#__PURE__*/_react["default"].createElement(_angleDoubleDownIcon["default"], null),
    text: 'Low'
  },
  2: {
    icon: /*#__PURE__*/_react["default"].createElement(_equalsIcon["default"], null),
    text: 'Moderate'
  },
  3: {
    icon: /*#__PURE__*/_react["default"].createElement(_angleDoubleUpIcon["default"], null),
    text: 'Important'
  },
  4: {
    icon: /*#__PURE__*/_react["default"].createElement(_CriticalIcon["default"], null),
    text: 'Critical'
  }
};

var InsightsLabel = function InsightsLabel(_ref) {
  var value = _ref.value,
      text = _ref.text,
      hideIcon = _ref.hideIcon,
      className = _ref.className,
      rest = _ref.rest;
  return /*#__PURE__*/_react["default"].createElement(_Label.Label, (0, _extends2["default"])({}, rest, {
    className: (0, _classnames["default"])(className, "ins-c-label-".concat(value)),
    icon: !hideIcon && VALUE_TO_STATE[value].icon
  }), text || VALUE_TO_STATE[value].text);
};

InsightsLabel.propTypes = {
  value: _propTypes["default"].number,
  text: _propTypes["default"].node,
  hideIcon: _propTypes["default"].bool,
  className: _propTypes["default"].string,
  rest: _propTypes["default"].object
};
InsightsLabel.defaultProps = {
  value: 1
};
var _default = InsightsLabel;
exports["default"] = _default;