"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _Title = require("@patternfly/react-core/dist/js/components/Title/Title.js");

var _Button = require("@patternfly/react-core/dist/js/components/Button/Button.js");

var _EmptyState = require("@patternfly/react-core/dist/js/components/EmptyState/EmptyState.js");

var _EmptyStateIcon = require("@patternfly/react-core/dist/js/components/EmptyState/EmptyStateIcon.js");

var _EmptyStateBody = require("@patternfly/react-core/dist/js/components/EmptyState/EmptyStateBody.js");

var _lockIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/lock-icon"));

require("./NotAuthorized.css");

var ContactBody = function ContactBody() {
  return /*#__PURE__*/_react["default"].createElement(_react["default"].Fragment, null, "Contact your organization administrator(s) for more information or visit\xA0", /*#__PURE__*/_react["default"].createElement("a", {
    href: "./settings/my-user-access"
  }, "My User Access"), "\xA0 to learn more about your permissions.");
};

var NotAuthorized = function NotAuthorized(_ref) {
  var prevPageButtonText = _ref.prevPageButtonText,
      toLandingPageText = _ref.toLandingPageText,
      title = _ref.title,
      actions = _ref.actions,
      serviceName = _ref.serviceName,
      Icon = _ref.icon,
      description = _ref.description,
      showReturnButton = _ref.showReturnButton,
      className = _ref.className,
      props = (0, _objectWithoutProperties2["default"])(_ref, ["prevPageButtonText", "toLandingPageText", "title", "actions", "serviceName", "icon", "description", "showReturnButton", "className"]);
  var heading = title || "You do not have access to ".concat(serviceName);
  return /*#__PURE__*/_react["default"].createElement(_EmptyState.EmptyState, (0, _extends2["default"])({
    variant: _EmptyState.EmptyStateVariant.full,
    className: "ins-c-not-authorized ".concat(className || '')
  }, props), /*#__PURE__*/_react["default"].createElement(_EmptyStateIcon.EmptyStateIcon, {
    icon: Icon
  }), /*#__PURE__*/_react["default"].createElement(_Title.Title, {
    headingLevel: "h5",
    size: "lg"
  }, heading), /*#__PURE__*/_react["default"].createElement(_EmptyStateBody.EmptyStateBody, null, description), actions, showReturnButton && (document.referrer ? /*#__PURE__*/_react["default"].createElement(_Button.Button, {
    variant: "primary",
    onClick: function onClick() {
      return history.back();
    }
  }, prevPageButtonText) : /*#__PURE__*/_react["default"].createElement(_Button.Button, {
    variant: "primary",
    component: "a",
    href: "."
  }, toLandingPageText)));
};

var serviceNamePropType = function serviceNamePropType(props, propName, componentName) {
  if (typeof props.title === 'undefined') {
    var _PropTypes$node;

    for (var _len = arguments.length, args = new Array(_len > 3 ? _len - 3 : 0), _key = 3; _key < _len; _key++) {
      args[_key - 3] = arguments[_key];
    }

    return (_PropTypes$node = _propTypes["default"].node).isRequired.apply(_PropTypes$node, [props, propName, componentName].concat(args));
  }
};

NotAuthorized.propTypes = {
  serviceName: serviceNamePropType,
  icon: _propTypes["default"].func,
  description: _propTypes["default"].node,
  showReturnButton: _propTypes["default"].bool,
  className: _propTypes["default"].string,
  title: _propTypes["default"].node,
  actions: _propTypes["default"].oneOfType([_propTypes["default"].node, _propTypes["default"].arrayOf(_propTypes["default"].node)]),
  prevPageButtonText: _propTypes["default"].node,
  toLandingPageText: _propTypes["default"].node
};
NotAuthorized.defaultProps = {
  icon: _lockIcon["default"],
  showReturnButton: true,
  description: /*#__PURE__*/_react["default"].createElement(ContactBody, null),
  actions: null,
  prevPageButtonText: 'Return to previous page',
  toLandingPageText: 'Go to landing page'
};
var _default = NotAuthorized;
exports["default"] = _default;