"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.actionPropsGenerator = exports.overflowActionsMapper = void 0;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _toArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireWildcard(require("react"));

var _Dropdown = require("@patternfly/react-core/dist/js/components/Dropdown/Dropdown.js");

var _DropdownItem = require("@patternfly/react-core/dist/js/components/Dropdown/DropdownItem.js");

var _KebabToggle = require("@patternfly/react-core/dist/js/components/Dropdown/KebabToggle.js");

var _Button = require("@patternfly/react-core/dist/js/components/Button/Button.js");

var _DropdownSeparator = require("@patternfly/react-core/dist/js/components/Dropdown/DropdownSeparator.js");

var _ToolbarItem = require("@patternfly/react-core/dist/js/components/Toolbar/ToolbarItem.js");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _DownloadButton = require("../DownloadButton");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var overflowActionsMapper = function overflowActionsMapper(action, key) {
  return /*#__PURE__*/_react["default"].createElement(_DropdownItem.DropdownItem, (0, _extends2["default"])({}, action.props, {
    className: "ins-c-primary-toolbar__overflow-actions",
    key: action.value || action.key || "".concat(key, "-overflow"),
    component: action.props && action.props.component || /*#__PURE__*/_react["default"].isValidElement(action.label || action) ? 'div' : 'button',
    onClick: function onClick(e) {
      return action.onClick && action.onClick(e, action, key);
    }
  }), action.label || action);
};

exports.overflowActionsMapper = overflowActionsMapper;

var actionPropsGenerator = function actionPropsGenerator(action, key) {
  return _objectSpread(_objectSpread({}, action.props), {}, {
    component: action.props && action.props.component || ( /*#__PURE__*/_react["default"].isValidElement(action.label || action) ? 'div' : 'button'),
    onClick: function onClick(e) {
      return action.onClick && action.onClick(e, action, key);
    },
    children: action.label || action
  });
};

exports.actionPropsGenerator = actionPropsGenerator;

var Actions = /*#__PURE__*/function (_Component) {
  (0, _inherits2["default"])(Actions, _Component);

  var _super = _createSuper(Actions);

  function Actions() {
    var _this;

    (0, _classCallCheck2["default"])(this, Actions);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "state", {
      isOpen: false
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "toggleOpen", function (isOpen) {
      _this.setState({
        isOpen: isOpen
      });
    });
    return _this;
  }

  (0, _createClass2["default"])(Actions, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var isOpen = this.state.isOpen;
      var _this$props = this.props,
          actions = _this$props.actions,
          overflowActions = _this$props.overflowActions,
          _onSelect = _this$props.onSelect,
          dropdownProps = _this$props.dropdownProps,
          kebabToggleProps = _this$props.kebabToggleProps,
          exportConfig = _this$props.exportConfig;

      var _actions = (0, _toArray2["default"])(actions),
          firstAction = _actions[0],
          restActions = _actions.slice(1);

      return /*#__PURE__*/_react["default"].createElement(_react.Fragment, null, firstAction && /*#__PURE__*/_react["default"].createElement(_ToolbarItem.ToolbarItem, {
        className: "ins-c-primary-toolbar__first-action pf-m-spacer-sm"
      }, firstAction.label ? /*#__PURE__*/_react["default"].createElement(_Button.Button, (0, _extends2["default"])({}, firstAction.props, {
        onClick: firstAction.onClick || firstAction.props && firstAction.props.onClick || undefined
      }), firstAction.label) : firstAction), exportConfig && (exportConfig.extraItems || exportConfig.onSelect) && /*#__PURE__*/_react["default"].createElement(_ToolbarItem.ToolbarItem, {
        className: "pf-m-spacer-sm"
      }, /*#__PURE__*/_react["default"].createElement(_DownloadButton.DownloadButton, exportConfig)), (actions && actions.length > 0 || overflowActions.length > 0) && /*#__PURE__*/_react["default"].createElement(_ToolbarItem.ToolbarItem, {
        className: "".concat(actions.length <= 1 ? 'ins-m-actions--empty' : '', " ins-c-primary-toolbar__actions pf-m-spacer-sm")
      }, /*#__PURE__*/_react["default"].createElement(_Dropdown.Dropdown, (0, _extends2["default"])({}, dropdownProps, {
        isOpen: isOpen,
        isPlain: true,
        onSelect: function onSelect() {
          _onSelect && _onSelect.apply(void 0, arguments);

          _this2.toggleOpen(false);
        },
        toggle: /*#__PURE__*/_react["default"].createElement(_KebabToggle.KebabToggle, (0, _extends2["default"])({}, kebabToggleProps, {
          onToggle: function onToggle(isOpen) {
            return _this2.toggleOpen(isOpen);
          }
        })),
        dropdownItems: [].concat((0, _toConsumableArray2["default"])(firstAction ? [/*#__PURE__*/_react["default"].createElement(_DropdownItem.DropdownItem, (0, _extends2["default"])({
          key: "first-action"
        }, actionPropsGenerator(firstAction, 'first-action'), {
          className: "ins-c-primary-toolbar__first-action ".concat(firstAction.props && firstAction.props.className || '')
        }))] : []), (0, _toConsumableArray2["default"])(restActions.map(function (action, key) {
          return /*#__PURE__*/_react["default"].createElement(_DropdownItem.DropdownItem, (0, _extends2["default"])({
            key: action.key || action && action.props && action.props.key || key
          }, actionPropsGenerator(action, key)));
        })), (0, _toConsumableArray2["default"])(actions.length > 0 && overflowActions.length > 0 ? [/*#__PURE__*/_react["default"].createElement(_DropdownSeparator.DropdownSeparator, {
          key: "separator",
          className: "ins-c-primary-toolbar__overflow-actions-separator"
        })] : []), (0, _toConsumableArray2["default"])(overflowActions.map(overflowActionsMapper)))
      }))));
    }
  }]);
  return Actions;
}(_react.Component);

var actionsType = _propTypes["default"].arrayOf(_propTypes["default"].oneOfType([_propTypes["default"].node, _propTypes["default"].shape({
  label: _propTypes["default"].node,
  value: _propTypes["default"].oneOfType([_propTypes["default"].number, _propTypes["default"].string]),
  onClick: _propTypes["default"].func,
  props: _propTypes["default"].any
}), _propTypes["default"].string]));

Actions.propTypes = {
  actions: actionsType,
  onSelect: _propTypes["default"].func,
  overflowActions: actionsType,
  dropdownProps: _propTypes["default"].shape((0, _defineProperty2["default"])({}, _propTypes["default"].string, _propTypes["default"].any)),
  kebabToggleProps: _propTypes["default"].shape((0, _defineProperty2["default"])({}, _propTypes["default"].string, _propTypes["default"].any)),
  exportConfig: _propTypes["default"].shape(_DownloadButton.DownloadButton.propTypes)
};
Actions.defaultProps = {
  actions: [],
  overflowActions: [],
  dropdownProps: {},
  exportConfig: {},
  onSelect: function onSelect() {
    return undefined;
  }
};
var _default = Actions;
exports["default"] = _default;