"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

require("./tab-layout.css");

var TabLayout = function TabLayout(_ref) {
  var children = _ref.children,
      items = _ref.items,
      classNames = _ref.classNames,
      active = _ref.active,
      onTabClick = _ref.onTabClick,
      props = (0, _objectWithoutProperties2["default"])(_ref, ["children", "items", "classNames", "active", "onTabClick"]);
  return /*#__PURE__*/_react["default"].createElement("section", (0, _extends2["default"])({}, props, {
    className: (0, _classnames["default"])(classNames, 'ins-tab-layout'),
    "widget-type": "InsightsTabs"
  }), /*#__PURE__*/_react["default"].createElement("div", {
    className: "ins-tabs"
  }, items.map(function (oneItem) {
    return /*#__PURE__*/_react["default"].createElement("div", {
      key: oneItem.name,
      className: (0, _classnames["default"])({
        active: oneItem.name === active
      }),
      onClick: function onClick(event) {
        return onTabClick(event, oneItem);
      },
      "widget-type": "InsightsTabsItem",
      "widget-id": oneItem.name
    }, oneItem.title);
  })), /*#__PURE__*/_react["default"].createElement("div", {
    className: "ins-tab-content"
  }, children));
};

TabLayout.propTypes = {
  items: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    name: _propTypes["default"].string,
    title: _propTypes["default"].node
  })),
  children: _propTypes["default"].node,
  classNames: _propTypes["default"].string,
  active: _propTypes["default"].string,
  onTabClick: _propTypes["default"].func
};
TabLayout.defaultProps = {
  items: [],
  onTabClick: function onTabClick() {
    return undefined;
  }
};
var _default = TabLayout;
exports["default"] = _default;