"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _Button = require("@patternfly/react-core/dist/js/components/Button/Button.js");

var _Stack = require("@patternfly/react-core/dist/js/layouts/Stack/Stack.js");

var _StackItem = require("@patternfly/react-core/dist/js/layouts/Stack/StackItem.js");

require("./truncate.css");

var _sanitizeHtml = _interopRequireDefault(require("sanitize-html"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var Truncate = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2["default"])(Truncate, _React$Component);

  var _super = _createSuper(Truncate);

  function Truncate(props) {
    var _this;

    (0, _classCallCheck2["default"])(this, Truncate);
    _this = _super.call(this, props);
    _this.state = {
      showText: false
    };
    _this.toggleText = _this.toggleText.bind((0, _assertThisInitialized2["default"])(_this));
    return _this;
  }

  (0, _createClass2["default"])(Truncate, [{
    key: "toggleText",
    value: function toggleText(event) {
      event && event.preventDefault();
      this.setState({
        showText: !this.state.showText
      });
    }
  }, {
    key: "dangerousHtml",
    value: function dangerousHtml(text) {
      return {
        __html: (0, _sanitizeHtml["default"])(text)
      };
    }
  }, {
    key: "render",
    value: function render() {
      var truncateClasses = (0, _classnames["default"])('ins-c-truncate', this.props.className, (0, _defineProperty2["default"])({}, "is-inline", this.props.inline), (0, _defineProperty2["default"])({}, "is-block", !this.props.inline));
      var trimmedText = this.props.text.substring(0, this.props.length);
      var textOverflow = this.props.text.length > this.props.length;
      var showText = this.state.showText;

      var expandButton = /*#__PURE__*/_react["default"].createElement(_Button.Button, {
        className: "ins-c-expand-button",
        variant: "link",
        onClick: this.toggleText
      }, this.props.expandText);

      var collapseButton = /*#__PURE__*/_react["default"].createElement(_Button.Button, {
        className: "ins-c-collapse-button",
        variant: "link",
        onClick: this.toggleText
      }, this.props.collapseText);

      if (this.props.inline) {
        return /*#__PURE__*/_react["default"].createElement(_react["default"].Fragment, null, /*#__PURE__*/_react["default"].createElement("span", {
          className: truncateClasses,
          "widget-type": "InsightsTruncateInline",
          dangerouslySetInnerHTML: this.dangerousHtml(showText === false ? "".concat(trimmedText).concat(textOverflow ? '...' : '') : this.props.text)
        }), textOverflow && (showText === false ? expandButton : collapseButton));
      } else {
        return /*#__PURE__*/_react["default"].createElement(_Stack.Stack, {
          className: truncateClasses
        }, /*#__PURE__*/_react["default"].createElement(_StackItem.StackItem, null, /*#__PURE__*/_react["default"].createElement("span", {
          "widget-type": "InsightsTruncateBlock",
          dangerouslySetInnerHTML: this.dangerousHtml(showText === false ? "".concat(trimmedText).concat(textOverflow ? '...' : '') : this.props.text)
        })), textOverflow && /*#__PURE__*/_react["default"].createElement(_StackItem.StackItem, {
          className: this.props.spaceBetween && 'pf-u-mt-sm'
        }, showText === false ? expandButton : collapseButton));
      }
    }
  }]);
  return Truncate;
}(_react["default"].Component);

;
var _default = Truncate;
exports["default"] = _default;
Truncate.propTypes = {
  className: _propTypes["default"].string,
  text: _propTypes["default"].string,
  length: _propTypes["default"].number,
  expandText: _propTypes["default"].string,
  collapseText: _propTypes["default"].string,
  inline: _propTypes["default"].bool,
  spaceBetween: _propTypes["default"].bool
};
Truncate.defaultProps = {
  length: 150,
  expandText: 'Read more',
  collapseText: 'Collapse',
  text: ''
};