import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";

/* eslint max-len: 0 */
import React from 'react';
import propTypes from 'prop-types';
import classNames from 'classnames';
import CriticalBattery from './CriticalBattery';
import HighBattery from './HighBattery';
import MediumBattery from './MediumBattery';
import LowBattery from './LowBattery';
import NullBattery from './NullBattery';
import "../../Battery/./battery.css";
/**
 * This is the battery component that generates a 'battery'
 * which corresponds to a level 1-4
 * 1 - low, green - best case scenario
 * 2 - medium, yellow
 * 3 - high, orange
 * 4 - critical, red - worst case scenario
 * Also accepts a label which can be made invisible
 */

var Battery = function Battery(_ref) {
  var severity = _ref.severity,
      label = _ref.label,
      labelHidden = _ref.labelHidden,
      className = _ref.className,
      props = _objectWithoutProperties(_ref, ["severity", "label", "labelHidden", "className"]);

  var batteryClasses = classNames(className, 'ins-battery', _defineProperty({}, "ins-battery-".concat(severity), severity !== undefined));
  var ariaLabels = {};

  if (labelHidden) {
    ariaLabels = _defineProperty({}, 'aria-label', severity + ' ' + label);
  }

  function batteryLevels(severity) {
    switch (severity) {
      case 'critical':
      case 4:
        return /*#__PURE__*/React.createElement(CriticalBattery, null);

      case 'high':
      case 'error':
      case 3:
        return /*#__PURE__*/React.createElement(HighBattery, null);

      case 'medium':
      case 'warn':
      case 2:
        return /*#__PURE__*/React.createElement(MediumBattery, null);

      case 'low':
      case 'info':
      case 1:
        return /*#__PURE__*/React.createElement(LowBattery, null);

      default:
        // eslint-disable-next-line
        console.error('Warning: Unsupported value presented to battery component');
        return /*#__PURE__*/React.createElement(NullBattery, null);
    }
  }

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("i", _extends({
    className: batteryClasses
  }, ariaLabels, props, {
    "widget-type": "InsightsBattery",
    "widget-id": label
  }), /*#__PURE__*/React.createElement("svg", {
    version: "1.1",
    id: "battery_svg",
    x: "0px",
    y: "0px",
    viewBox: "0 0 448 512",
    style: {
      enableBackground: 'new 0 0 448 512'
    },
    shapeRendering: "geometricpresision"
  }, /*#__PURE__*/React.createElement("path", {
    style: {
      fill: 'none',
      fillOpacity: 1,
      stroke: '#969696',
      strokeWidth: 41.96378708,
      strokeLinejoin: 'round',
      strokeMiterlimit: 4,
      strokeDasharray: 'none',
      strokeDashoffset: 0,
      strokeOpacity: 1
    },
    d: "m 144.16452,21.032222 h 159.67454 q 123.1748,0 123.1748,128.667868 v 212.64759 q 0,128.66788 -123.1748,128.66788 H 144.16452 q -123.174811,0 -123.174811,-128.66788 V 149.70009 q 0,-128.667868 123.174811,-128.667868 z"
  }), batteryLevels(severity))), !labelHidden && /*#__PURE__*/React.createElement("span", {
    className: "label"
  }, " ", label, " "));
};

export default Battery;
Battery.propTypes = {
  severity: propTypes.oneOf([1, 2, 3, 4, 'info', 'low', 'warn', 'medium', 'error', 'high', 'critical']),
  label: propTypes.string.isRequired,
  labelHidden: propTypes.bool,
  className: propTypes.string
};
Battery.defaultProps = {
  severity: 'null'
};