import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import PropTypes from 'prop-types';
import React from 'react';
import classnames from 'classnames';
import { useOUIAId } from '@patternfly/react-core/';
var checkTypes = ['checkbox', 'radio'];

var Input = function Input(_ref) {
  var _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'text' : _ref$type,
      _ref$ariaLabel = _ref.ariaLabel,
      ariaLabel = _ref$ariaLabel === void 0 ? type : _ref$ariaLabel,
      className = _ref.className,
      ouiaId = _ref.ouiaId,
      ouiaSafe = _ref.ouiaSafe,
      props = _objectWithoutProperties(_ref, ["type", "ariaLabel", "className", "ouiaId", "ouiaSafe"]);

  var classes = checkTypes.indexOf(type) !== -1 ? 'pf-c-check' : 'pf-c-form-control';
  var ouiaComponentType = 'RHI/Input';
  var ouiaFinalId = useOUIAId(ouiaComponentType, ouiaId, ouiaSafe);
  return /*#__PURE__*/React.createElement("input", _extends({}, props, {
    "data-ouia-component-type": ouiaComponentType,
    "data-ouia-component-id": ouiaFinalId,
    "data-ouia-safe": ouiaSafe,
    type: type,
    "aria-label": ariaLabel,
    className: classnames(classes, className)
  }));
};

Input.propTypes = {
  type: PropTypes.string,
  className: PropTypes.string,
  ariaLabel: PropTypes.string,
  ouiaId: PropTypes.string,
  ouiaSafe: PropTypes.bool
};
Input.defaultProps = {
  ouiaSafe: true
};
export default Input;