import _extends from "@babel/runtime/helpers/extends";
import React, { Suspense } from 'react';
import PropTypes from 'prop-types';
import { ScalprumComponent } from '@scalprum/react-core';
import { useHistory } from 'react-router-dom';
import { useStore } from 'react-redux';
import { Bullseye } from "@patternfly/react-core/dist/esm/layouts/Bullseye/Bullseye.js";
import { Spinner } from "@patternfly/react-core/dist/esm/components/Spinner/Spinner.js";
import InventoryLoadError from './InventoryLoadError';

var BaseAppInfo = function BaseAppInfo(props) {
  var history = useHistory();
  var store = useStore();
  return /*#__PURE__*/React.createElement(Suspense, {
    fallback: props.fallback
  }, /*#__PURE__*/React.createElement(ScalprumComponent, _extends({
    history: history,
    store: store,
    appName: "inventory",
    module: "./AppInfo",
    scope: "inventory",
    ErrorComponent: /*#__PURE__*/React.createElement(InventoryLoadError, _extends({
      component: "InventoryDetailHead",
      history: history,
      store: store
    }, props)),
    ref: props.innerRef
  }, props)));
};

BaseAppInfo.propTypes = {
  fallback: PropTypes.node,
  innerRef: PropTypes.object
};
/**
 * Inventory sub component.
 *
 * This component shows tab(s) with detail information about selected system.
 */

var AppInfo = /*#__PURE__*/React.forwardRef(function (props, ref) {
  return /*#__PURE__*/React.createElement(BaseAppInfo, _extends({
    innerRef: ref
  }, props));
});
AppInfo.propTypes = {
  /** React Suspense fallback component. <a href="https://reactjs.org/docs/code-splitting.html#reactlazy" target="_blank">Learn more</a>. */
  fallback: PropTypes.node
};
AppInfo.defaultProps = {
  fallback: /*#__PURE__*/React.createElement(Bullseye, {
    className: "pf-u-p-lg"
  }, /*#__PURE__*/React.createElement(Spinner, {
    size: "xl"
  }))
};
export default AppInfo;