import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import { Tooltip } from "@patternfly/react-core/dist/esm/components/Tooltip/Tooltip.js";
import propTypes from 'prop-types';
import React from 'react';

var LongTextTooltip = /*#__PURE__*/function (_React$Component) {
  _inherits(LongTextTooltip, _React$Component);

  var _super = _createSuper(LongTextTooltip);

  function LongTextTooltip(props) {
    _classCallCheck(this, LongTextTooltip);

    return _super.call(this, props);
  }

  _createClass(LongTextTooltip, [{
    key: "truncate",
    value: function truncate(str, max) {
      return str.length > max ? str.substr(0, max - 1) + '…' : str;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          content = _this$props.content,
          maxLength = _this$props.maxLength,
          tooltipMaxWidth = _this$props.tooltipMaxWidth,
          tooltipPosition = _this$props.tooltipPosition,
          rest = _objectWithoutProperties(_this$props, ["content", "maxLength", "tooltipMaxWidth", "tooltipPosition"]);

      return /*#__PURE__*/React.createElement(React.Fragment, null, content.length > maxLength ? /*#__PURE__*/React.createElement(Tooltip, _extends({
        maxWidth: tooltipMaxWidth,
        position: tooltipPosition,
        content: /*#__PURE__*/React.createElement("div", null, content)
      }, rest), /*#__PURE__*/React.createElement("div", null, this.truncate(content, maxLength))) : /*#__PURE__*/React.createElement("span", null, content));
    }
  }]);

  return LongTextTooltip;
}(React.Component);

LongTextTooltip.defaultProps = {
  content: '',
  maxLength: Infinity,
  tooltipPosition: 'top',
  tooltipMaxWidth: '50vw'
};
LongTextTooltip.propTypes = {
  content: propTypes.string,
  maxLength: propTypes.number,
  tooltipPosition: propTypes.string,
  tooltipMaxWidth: propTypes.string
};
export default LongTextTooltip;