import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import "../../Spinner/./spinner.css";

var Spinner = function Spinner(_ref) {
  var centered = _ref.centered,
      className = _ref.className,
      props = _objectWithoutProperties(_ref, ["centered", "className"]);

  var spinnerClasses = classNames('ins-c-spinner', _defineProperty({}, "ins-m-center", centered), className);
  return /*#__PURE__*/React.createElement("div", _extends({
    role: "status",
    className: spinnerClasses
  }, props), /*#__PURE__*/React.createElement("span", {
    className: "pf-u-screen-reader"
  }, "Loading..."));
};

Spinner.propTypes = {
  centered: PropTypes.bool,
  className: PropTypes.string
};
export default Spinner;