import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import React, { Fragment } from 'react';
import { Toolbar } from "@patternfly/react-core/dist/esm/components/Toolbar/Toolbar.js";
import { useOUIAId } from '@patternfly/react-core/';
import classNames from 'classnames';
import propTypes from 'prop-types';
import "../../TableToolbar/./TableToolbar.css";

function generateCount(results) {
  if (results > 1 || results < 1) {
    return "".concat(results, " Results");
  } else {
    return "".concat(results, " Result");
  }
}

var TableToolbar = function TableToolbar(_ref) {
  var isFooter = _ref.isFooter,
      results = _ref.results,
      className = _ref.className,
      selected = _ref.selected,
      children = _ref.children,
      ouiaId = _ref.ouiaId,
      _ref$ouiaSafe = _ref.ouiaSafe,
      ouiaSafe = _ref$ouiaSafe === void 0 ? true : _ref$ouiaSafe,
      props = _objectWithoutProperties(_ref, ["isFooter", "results", "className", "selected", "children", "ouiaId", "ouiaSafe"]);

  var tableToolbarClasses = classNames('ins-c-table__toolbar', _defineProperty({}, "ins-m-footer", isFooter), className);
  var ouiaComponentType = 'RHI/TableToolbar';
  var ouiaFinalId = useOUIAId(ouiaComponentType, ouiaId, ouiaSafe);
  return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(Toolbar, _extends({
    className: tableToolbarClasses,
    "data-ouia-component-type": ouiaComponentType,
    "data-ouia-component-id": ouiaFinalId,
    "data-ouia-safe": ouiaSafe
  }, props), children), (results >= 0 || selected >= 0) && /*#__PURE__*/React.createElement("div", {
    className: "ins-c-table__toolbar-results"
  }, results >= 0 && /*#__PURE__*/React.createElement("span", {
    className: "ins-c-table__toolbar-results-count"
  }, " ", generateCount(results), " "), selected >= 0 && /*#__PURE__*/React.createElement("span", {
    className: "ins-c-table__toolbar-results-selected"
  }, " ", selected, " Selected ")));
};

export default TableToolbar;
TableToolbar.propTypes = {
  isFooter: propTypes.bool,
  results: propTypes.number,
  children: propTypes.any,
  className: propTypes.string,
  selected: propTypes.number,
  ouiaId: propTypes.string,
  ouiaSafe: propTypes.bool
};
TableToolbar.defaultProps = {
  isFooter: false
};