import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
export var sizeCalculator = function sizeCalculator(rows) {
  var points = {};

  for (var key = 0; key < rows.length; key++) {
    if (!rows[key].cells) {
      rows[key] = {
        cells: rows[key]
      };
    }

    var currRow = rows[key];
    currRow.level = rows[currRow.treeParent] ? rows[currRow.treeParent].level + 1 : 0;
    var pointKey = typeof currRow.treeParent === 'undefined' ? 0 : currRow.treeParent + 1;

    if (!points[pointKey]) {
      points[pointKey] = {
        size: 0
      };
    }

    var currPoint = points[pointKey];
    currPoint.size = currPoint.size + 1;
    currRow.point = currPoint;
    currRow.posinset = currPoint.size;
  }

  return rows;
};
export var collapseBuilder = function collapseBuilder() {
  var parentKey = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'treeParent';
  return function (rows, _e, _val, _ref) {
    var rowData = _ref.rowData;
    var currRow = rows[rowData.id];
    var isTreeOpen = !currRow.isTreeOpen;
    var rowsToChange = [rows[rowData.id]].concat(_toConsumableArray(isTreeOpen === false ? rows.filter(function (row) {
      return row[parentKey] === rowData.id;
    }) : []));

    for (var key = 0; key < rowsToChange.length; key++) {
      rowsToChange[key].isTreeOpen = rowsToChange[key].isTreeOpen === undefined ? undefined : isTreeOpen;
    }

    return rows;
  };
};