import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import { useEffect, useRef, useState } from 'react';
import getVariant from './getVariant';

var useScreen = function useScreen() {
  var _useState = useState(function () {
    return getVariant();
  }),
      _useState2 = _slicedToArray(_useState, 2),
      variant = _useState2[0],
      setVariant = _useState2[1];

  var prev = useRef(variant);
  useEffect(function () {
    function handleResize() {
      var newVariant = getVariant();

      if (newVariant !== prev.current) {
        prev.current = newVariant;
        setVariant(newVariant);
      }
    }

    window.addEventListener('resize', handleResize);
    return function () {
      return window.removeEventListener('resize', handleResize);
    };
  }, []);
  return variant;
};

export default useScreen;