import { SourceFile, TransformerFactory } from 'typescript';
/**
 * Create a ReactRefresh transformer for TypeScript.
 *
 * This transformer should run in the before stage.
 *
 * This transformer requires TypeScript to be at least 4.0.
 */
export default function (opts?: Options): TransformerFactory<SourceFile>;
export declare type Options = {
    /** @default "$RefreshReg$" */
    readonly refreshReg?: string;
    /** @default "$RefreshSig$" */
    readonly refreshSig?: string;
    /** @default false */
    readonly emitFullSignatures?: boolean;
    /** Provide your own TypeScript instance. */
    readonly ts?: typeof import('typescript');
    /** Provide your own hash function when `emitFullSignatures` is `false` */
    readonly hashSignature?: (signature: string) => string;
};
