import React from 'react';
import { Text } from "@patternfly/react-core/dist/esm/components/Text/Text.js";
import { TextVariants } from "@patternfly/react-core/dist/esm/components/Text/Text.js";
import PropTypes from 'prop-types';

var RiskDescription = function RiskDescription(_ref) {
  var riskValue = _ref.riskValue,
      riskMeta = _ref.riskMeta,
      showDescription = _ref.showDescription;
  // riskValue ranges from 1 to ∞
  var _riskMeta = riskMeta[riskValue - 1],
      IconComponent = _riskMeta.IconComponent,
      description = _riskMeta.description;
  return /*#__PURE__*/React.createElement("div", {
    className: "ins-c-rule__risk-description"
  }, /*#__PURE__*/React.createElement(IconComponent, {
    value: riskValue
  }), showDescription && /*#__PURE__*/React.createElement(Text, {
    className: "ins-c-rule__risk-detail-description-text",
    component: TextVariants.small
  }, description));
};

RiskDescription.propTypes = {
  riskValue: PropTypes.number,
  riskMeta: PropTypes.array,
  showDescription: PropTypes.bool
};
export default RiskDescription;