import { __rest } from "tslib";
import * as React from 'react';
import { Button, Tooltip } from '@patternfly/react-core';
import { CodeEditorContext } from './CodeEditorUtils';
export const CodeEditorControl = (_a) => {
    var { icon, className, 'aria-label': ariaLabel, toolTipText, exitDelay = 0, entryDelay = 300, maxWidth = '100px', position = 'top', onClick = () => { }, isVisible = true } = _a, props = __rest(_a, ["icon", "className", 'aria-label', "toolTipText", "exitDelay", "entryDelay", "maxWidth", "position", "onClick", "isVisible"]);
    const context = React.useContext(CodeEditorContext);
    const onCustomClick = (event) => {
        onClick(context.code, event);
    };
    return isVisible ? (React.createElement(Tooltip, { trigger: "mouseenter focus click", exitDelay: exitDelay, entryDelay: entryDelay, maxWidth: maxWidth, position: position, content: React.createElement("div", null, toolTipText) },
        React.createElement(Button, Object.assign({ className: className, onClick: onCustomClick, variant: "control", "aria-label": ariaLabel }, props), icon))) : null;
};
CodeEditorControl.displayName = 'CodeEditorControl';
//# sourceMappingURL=CodeEditorControl.js.map