import { Event, Response, Session, TransportOptions } from '@sentry/types';
import { BaseTransport } from './base';
declare type FetchImpl = typeof fetch;
/** `fetch` based transport */
export declare class FetchTransport extends BaseTransport {
    /**
     * Fetch API reference which always points to native browser implementation.
     */
    private _fetch;
    constructor(options: TransportOptions, fetchImpl?: FetchImpl);
    /**
     * @inheritDoc
     */
    sendEvent(event: Event): PromiseLike<Response>;
    /**
     * @inheritDoc
     */
    sendSession(session: Session): PromiseLike<Response>;
    /**
     * @param sentryRequest Prepared SentryRequest to be delivered
     * @param originalPayload Original payload used to create SentryRequest
     */
    private _sendRequest;
}
export {};
//# sourceMappingURL=fetch.d.ts.map