"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScalprumLink = void 0;
var react_1 = __importDefault(require("react"));
var core_1 = require("@scalprum/core");
var react_router_dom_1 = require("react-router-dom");
var ScalprumLink = function (_a) {
    var to = _a.to, onClick = _a.onClick, shouldUnmount = _a.shouldUnmount, unmount = _a.unmount, props = __rest(_a, ["to", "onClick", "shouldUnmount", "unmount"]);
    var pathname = react_router_dom_1.useLocation().pathname;
    return (react_1.default.createElement(react_router_dom_1.Link, __assign({ onClick: function (event) {
            var unmountResult;
            var unmountFunction = unmount || (function () { return core_1.unmountAppsFromRoute(pathname); });
            if (typeof shouldUnmount === 'undefined') {
                unmountResult = (typeof to === 'string' && pathname !== to) || (typeof to === 'object' && pathname !== to.pathname);
            }
            else if (typeof shouldUnmount === 'boolean') {
                unmountResult = shouldUnmount;
            }
            else if (typeof shouldUnmount === 'function') {
                unmountResult = shouldUnmount(pathname, to);
            }
            if (unmountResult) {
            }
            if (onClick) {
                onClick(event);
            }
        }, to: to }, props)));
};
exports.ScalprumLink = ScalprumLink;
//# sourceMappingURL=scalprum-link.js.map