"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScalprumRoute = void 0;
var core_1 = require("@scalprum/core");
var react_1 = __importStar(require("react"));
var react_dom_1 = require("react-dom");
var react_router_dom_1 = require("react-router-dom");
var ScalprumRoute = function (_a) {
    var _b;
    var _c = _a.Placeholder, Placeholder = _c === void 0 ? react_1.Fragment : _c, elementId = _a.elementId, appName = _a.appName, path = _a.path, api = _a.api, props = __rest(_a, ["Placeholder", "elementId", "appName", "path", "api"]);
    var scriptLocation = ((_b = core_1.getAppsByRootLocation(path)) === null || _b === void 0 ? void 0 : _b[0]).scriptLocation;
    react_1.useEffect(function () {
        var app = core_1.getApp(appName);
        var element = document.getElementById(elementId);
        if (!app) {
            core_1.injectScript(appName, scriptLocation).then(function () {
                var app = core_1.getApp(appName);
                var node = app.mount(api);
                react_dom_1.render(node, element);
            });
        }
        else {
            var node = app.mount(api);
            react_dom_1.render(node, element);
        }
        return function () {
            var app = core_1.getApp(appName);
            app.unmount();
            react_dom_1.unmountComponentAtNode(element);
        };
    }, [path]);
    return (react_1.default.createElement(react_router_dom_1.Route, __assign({}, props, { path: path }),
        react_1.default.createElement("div", { id: elementId },
            react_1.default.createElement(Placeholder, null))));
};
exports.ScalprumRoute = ScalprumRoute;
//# sourceMappingURL=scalprum-route.js.map