"use strict";
// Misc util functions
Object.defineProperty(exports, "__esModule", { value: true });
exports.getClassName = exports.canUseDOM = void 0;
// Copied from exenv
exports.canUseDOM = !!(typeof window !== 'undefined' && window.document && window.document.createElement);
// Returns the class name that will be applied to the outer-most div rendered by the chart's container
const getClassName = ({ className }) => {
    let cleanClassName;
    // Workaround for VictoryContainer class name
    if (className) {
        cleanClassName = className
            .replace(/VictoryContainer/g, '')
            .replace(/pf-c-chart/g, '')
            .replace(/\s+/g, ' ')
            .trim();
    }
    return cleanClassName && cleanClassName.length ? `pf-c-chart ${cleanClassName}` : 'pf-c-chart';
};
exports.getClassName = getClassName;
//# sourceMappingURL=chart-helpers.js.map