export declare const GLOBAL_NAMESPACE = "__scalprum__";
export interface AppMetadata {
    name: string;
    appId?: string;
    elementId?: string;
    rootLocation?: string;
    scriptLocation?: string;
    manifestLocation?: string;
}
export interface AppsConfig {
    [key: string]: AppMetadata;
}
export interface AppInitConfig<T> extends Omit<Omit<Scalplet<T>, 'nodeId'>, 'mount'> {
    id: string;
    name: string;
    mount(api: Scalprum<T>): void;
}
export declare type Scalprum<T = any> = T & {
    apps: {
        [key: string]: Scalplet<T>;
    };
    appsMetaData: AppsConfig;
    activeApps: {
        [key: string]: boolean;
    };
    scalpletRoutes: {
        [key: string]: string[];
    };
    pendingInjections: {
        [key: string]: () => void;
    };
};
export interface Scalplet<T> {
    mount<A = void>(api?: T): A;
    unmount(...args: any[]): void;
    update(): void;
    nodeId: string;
}
declare global {
    interface Window {
        [GLOBAL_NAMESPACE]: Scalprum;
    }
}
export declare const getScalprum: <T = Record<string, unknown>>() => Scalprum<T>;
export declare const setPendingInjection: (id: string, callback: () => void) => void;
export declare const initialize: <T = unknown>({ scalpLets, api }: {
    scalpLets: AppsConfig;
    api?: T | undefined;
}) => void;
export declare const setActiveApp: (name: string) => void;
export declare const removeActiveApp: (name: string) => void;
export declare const unmountAppsFromRoute: (route: string) => void;
export declare const unmountAll: () => void;
export declare function initializeApp<T extends Record<string, unknown>>(configuration: AppInitConfig<T>): void;
export declare const getApp: <T = unknown>(name: string) => Scalplet<T>;
export declare const getAppData: (name: string) => AppMetadata;
export declare const getAppsByRootLocation: (pathname: string) => AppMetadata[];
export declare const injectScript: (appName: string, scriptLocation: string, skipPending?: boolean | undefined) => Promise<[unknown, HTMLScriptElement | undefined]>;
export declare function processManifest(url: string, appName: string, scope: string, processor: ((value: any) => string) | undefined): Promise<[unknown, HTMLScriptElement | undefined][]>;
