import { Host, HostsTableActions } from '../../../common';
import { AgentK8sResource, InfraEnvK8sResource } from '../../types';
import { ActionsResolver, TableRow } from '../../../common/components/hosts/AITable';
import { ClusterDeploymentHostsTablePropsActions } from '../ClusterDeployment/types';
import { BareMetalHostK8sResource } from '../../types/k8s/bare-metal-host';
export declare const discoveryTypeColumn: (agents: AgentK8sResource[], bareMetalHosts: BareMetalHostK8sResource[]) => TableRow<Host>;
declare type StatusColumnProps = {
    agents: AgentK8sResource[];
    bareMetalHosts?: BareMetalHostK8sResource[];
    onEditHostname?: ClusterDeploymentHostsTablePropsActions['onEditHost'];
    onApprove?: ClusterDeploymentHostsTablePropsActions['onApprove'];
};
export declare const infraEnvStatusColumn: ({ agents, bareMetalHosts, onEditHostname, onApprove, }: StatusColumnProps) => TableRow<Host>;
export declare const clusterColumn: (agents: AgentK8sResource[], getClusterDeploymentLink: (cd: {
    name: string;
    namespace: string;
}) => string) => TableRow<Host>;
export declare const infraEnvColumn: (agents: AgentK8sResource[]) => TableRow<Host>;
export declare const networkingStatusColumn: (onEditHostname?: HostsTableActions['onEditHost']) => TableRow<Host>;
declare type AgentsTableResources = {
    agents: AgentK8sResource[];
    bmhs?: BareMetalHostK8sResource[];
    infraEnv?: InfraEnvK8sResource;
};
export declare const useAgentsTable: ({ onEditHost, canEditHost, onDeleteHost, canDelete, onEditRole, canEditRole, onSelect, onEditBMH, }: ClusterDeploymentHostsTablePropsActions, { agents, bmhs, infraEnv }: AgentsTableResources) => [Host[], HostsTableActions, ActionsResolver<Host>];
export {};
