import { AgentClusterInstallK8sResource } from '../../types/k8s/agent-cluster-install';
import { Cluster, Host } from '../../../common';
import { AgentK8sResource } from '../../types/k8s/agent';
import { BareMetalHostK8sResource } from '../../types';
import { ValidationsInfo } from '../../../common/types/hosts';
export declare const getClusterStatusFromConditions: (agentClusterInstall: AgentClusterInstallK8sResource) => [Cluster['status'], string];
export declare const getClusterStatus: (agentClusterInstall?: AgentClusterInstallK8sResource | undefined) => [Cluster['status'], Cluster['statusInfo']];
export declare const isDraft: (agentClusterInstall?: AgentClusterInstallK8sResource | undefined) => boolean;
export declare const getAgentStatusFromConditions: (agent: AgentK8sResource) => [Host['status'], string];
export declare type AgentStatus = Host['status'] | 'Discovered';
export declare const getAgentStatus: (agent: AgentK8sResource, excludeDiscovered?: boolean) => [AgentStatus, Host['statusInfo'], ValidationsInfo];
export declare const getBMHStatus: (bmh: BareMetalHostK8sResource) => {
    title: string | undefined;
    message: string | undefined;
};
