import React from 'react';
import { ICell, IAction, ISeparator } from '@patternfly/react-table';
import { WithTestID } from '../../types';
import './HostsTable.css';
export declare type TableRow<R> = {
    header: ICell | string;
    cell?: (obj: R) => {
        title: React.ReactNode;
        props: any;
        sortableValue?: string | number;
    };
};
export declare type ActionsResolver<R> = (obj: R) => (IAction | ISeparator)[];
export declare type ExpandComponentProps<R> = {
    obj: R;
};
declare type HostsTable<R> = {
    data: R[];
    content: TableRow<R>[];
    ExpandComponent: React.ComponentType<ExpandComponentProps<R>>;
    children: React.ReactNode;
    getDataId: (obj: R) => string;
    onSelect?: (obj: R, isSelected: boolean) => void;
    selectedIDs?: string[];
    className?: string;
    actionResolver?: ActionsResolver<R>;
};
declare const AITable: <R extends unknown>({ data, testId, className, content, ExpandComponent, getDataId, actionResolver, onSelect, children, selectedIDs, }: WithTestID & HostsTable<R>) => JSX.Element;
export default AITable;
