import filesize from 'filesize.js';
import { Host, Cluster, Inventory } from '../../api/types';
export declare const canEnable: (clusterStatus: Cluster['status'], status: Host['status']) => boolean;
export declare const canDisable: (clusterStatus: Cluster['status'], status: Host['status']) => boolean;
export declare const canDelete: (clusterStatus: Cluster['status'], status: Host['status']) => boolean;
export declare const canReset: (clusterStatus: Cluster['status'], status: Host['status']) => boolean;
export declare const canEditRole: (cluster: Cluster, hostStatus: Host['status']) => boolean;
export declare const canEditHost: (clusterStatus: Cluster['status'], status: Host['status']) => boolean;
export declare const canEditDisks: (clusterStatus: Cluster['status'], status: Host['status']) => boolean;
export declare const canDownloadKubeconfig: (clusterStatus: Cluster['status']) => boolean;
export declare const canInstallHost: (cluster: Cluster, hostStatus: Host['status']) => boolean;
export declare const getHostProgressStages: (host: Host) => import("../../api/types").HostStage[];
export declare const getHostProgress: (host: Host) => import("../../api/types").HostProgressInfo | {
    currentStage: "Preparing installation";
    progressInfo: undefined;
};
export declare const getHostProgressStageNumber: (host: Host) => number;
export declare const canHostnameBeChanged: (hostStatus: Host['status']) => boolean;
export declare const getHostRole: (host: Host) => string;
export declare const canDownloadHostLogs: (host: Host) => boolean;
export declare const canDownloadClusterLogs: (cluster: Cluster) => boolean;
export declare const getReadyHostCount: (cluster: Cluster) => number;
export declare const getEnabledHostCount: (cluster: Cluster) => number;
export declare const getTotalHostCount: (cluster: Cluster) => number;
export declare const getEnabledHosts: (hosts?: Host[]) => Host[];
export declare const getHostname: (host: Host, inventory: Inventory) => string | undefined;
export declare const getHardwareTypeText: (inventory: Inventory) => string;
export declare const fileSize: typeof filesize;
