import * as Yup from 'yup';
import { NetworkConfigurationValues, HostSubnets } from '../../../types/clusters';
import { ProxyFieldsType } from '../../../types';
export declare const nameValidationSchema: (usedClusterNames: string[], baseDnsDomain?: string) => Yup.StringSchema<string>;
export declare const sshPublicKeyValidationSchema: Yup.StringSchema<string>;
export declare const pullSecretValidationSchema: Yup.StringSchema<string>;
export declare const ipValidationSchema: Yup.StringSchema<string>;
export declare const macAddressValidationSchema: Yup.StringSchema<string>;
export declare const vipRangeValidationSchema: (hostSubnets: HostSubnets, { hostSubnet }: NetworkConfigurationValues) => Yup.StringSchema<string>;
export declare const vipValidationSchema: (hostSubnets: HostSubnets, values: NetworkConfigurationValues, initialValue?: string | undefined) => Yup.MixedSchema<any>;
export declare const ipBlockValidationSchema: Yup.StringSchema<string>;
export declare const dnsNameValidationSchema: Yup.StringSchema<string>;
export declare const hostPrefixValidationSchema: ({ clusterNetworkCidr, }: Partial<NetworkConfigurationValues>) => Yup.NumberSchema<number>;
export declare const hostnameValidationSchema: Yup.StringSchema<string>;
export declare const uniqueHostnameValidationSchema: (origHostname: string, usedHostnames: string[]) => Yup.StringSchema<string>;
export declare const httpProxyValidationSchema: (values: ProxyFieldsType, pairValueName: 'httpProxy' | 'httpsProxy') => Yup.StringSchema<string>;
export declare const noProxyValidationSchema: Yup.StringSchema<string>;
export declare const ntpSourceValidationSchema: Yup.StringSchema<string>;
