import { ValidationsInfo, HostRole } from '../../common/types/hosts';
import { Cluster, ClusterValidationId, DiskRole, Event, Host, HostValidationId } from '../api';
export declare const OPENSHIFT_LIFE_CYCLE_DATES_LINK = "https://access.redhat.com/support/policy/updates/openshift#dates";
export declare const OPENSHIFT_NETWORKING_DOCS_LINK = "https://docs.openshift.com/container-platform/4.7/installing/installing_bare_metal/installing-bare-metal.html#installation-network-user-infra_installing-bare-metal";
export declare const CLUSTER_MANAGER_SITE_LINK = "https://cloud.redhat.com/openshift/install/pull-secret";
export declare const PULL_SECRET_INFO_LINK = "https://cloud.redhat.com/openshift/install/pull-secret";
export declare const VSPHERE_CONFIG_LINK = "https://issues.redhat.com/secure/attachment/12531134/12531134_How+to+modify+the+vSphere+configuration+in+OpenShift+4.x+-+Red+Hat+Customer+Portal.pdf";
export declare const getBugzillaLink: (version?: string) => string;
export declare const FEEDBACK_FORM_LINK = "https://docs.google.com/forms/d/e/1FAIpQLSfg9M8wRW4m_HkWeAl6KpB5dTcMu8iI3iJ29GlLfZpF2hnjng/viewform";
export declare const getOcpConsoleNodesPage: (ocpConsoleUrl: string) => string;
export declare const getProductBrandingCode: () => string;
export declare const POLLING_INTERVAL: number;
export declare const EVENTS_POLLING_INTERVAL: number;
export declare const HOST_ROLES: HostRole[];
export declare const CLUSTER_STATUS_LABELS: {
    [key in Cluster['status']]: string;
};
export declare const HOST_STATUS_LABELS: {
    [key in Host['status']]: string;
};
export declare const CLUSTER_FIELD_LABELS: {
    [key in string]: string;
};
export declare const HOST_STATUS_DETAILS: {
    [key in Host['status']]: string;
};
export declare const HOST_VALIDATION_GROUP_LABELS: {
    [key in keyof ValidationsInfo]: string;
};
export declare const HOST_VALIDATION_LABELS: {
    [key in HostValidationId]: string;
};
export declare const HOST_VALIDATION_FAILURE_HINTS: {
    [key in HostValidationId]: string;
};
export declare const CLUSTER_VALIDATION_LABELS: {
    [key in ClusterValidationId]: string;
};
export declare const CLUSTER_DEFAULT_NETWORK_SETTINGS_IPV4: {
    clusterNetworkCidr: string;
    clusterNetworkHostPrefix: number;
    serviceNetworkCidr: string;
};
export declare const CLUSTER_DEFAULT_NETWORK_SETTINGS_IPV6: {
    clusterNetworkCidr: string;
    clusterNetworkHostPrefix: number;
    serviceNetworkCidr: string;
};
export declare const getAssistedUiLibVersion: () => string;
export declare const EVENT_SEVERITIES: Event['severity'][];
export declare const TIME_ZERO = "0001-01-01T00:00:00.000Z";
export declare const NO_SUBNET_SET = "NO_SUBNET_SET";
export declare const PREFIX_MAX_RESTRICTION: {
    IPv6: number;
    IPv4: number;
};
export declare const DISK_ROLE_LABELS: {
    [key in DiskRole]: string;
};
export declare const SNO_SUPPORT_MIN_VERSION = 4.8;
export declare const OPERATOR_NAME_CNV = "cnv";
export declare const OPERATOR_NAME_LSO = "lso";
export declare const OPERATOR_NAME_OCS = "ocs";
export declare const OPERATOR_NAME_CVO = "cvo";
export declare const OPERATOR_NAME_CONSOLE = "console";
export declare const OPERATOR_LABELS: {
    console: string;
    cvo: string;
    lso: string;
    ocs: string;
    cnv: string;
};
export declare const OCP_STATIC_IP_DOC = "https://docs.openshift.com/container-platform/latest/scalability_and_performance/ztp-deploying-disconnected.html#ztp-configuring-a-static-ip_ztp-deploying-disconnected";
