import { IRow } from '@patternfly/react-table';
import { ClusterUpdateParams, ClusterValidationId } from '../api/types';
import { Validation as HostValidation } from './hosts';
export declare type Validation = Omit<HostValidation, 'id'> & {
    id: ClusterValidationId;
};
export declare type ValidationGroup = 'configuration' | 'hostsData' | 'network' | 'operators';
export declare type ValidationsInfo = {
    [key in ValidationGroup]?: Validation[];
};
export declare type ClusterTableRows = IRow[];
export declare type HostSubnet = {
    subnet: string;
    hostIDs: string[];
    humanized: string;
};
export declare type HostSubnets = HostSubnet[];
export declare type NetworkConfigurationValues = ClusterUpdateParams & {
    hostSubnet?: string;
    useRedHatDnsService?: boolean;
    managedNetworkingType: 'userManaged' | 'clusterManaged';
};
export declare type HostDiscoveryValues = ClusterUpdateParams & {
    useExtraDisksForLocalStorage: boolean;
    useContainerNativeVirtualization: boolean;
    usePlatformIntegration: boolean;
};
